import { SpeechSynthesisBoundaryType } from "./SpeechSynthesisBoundaryType";
/**
 * Defines contents of speech synthesis word boundary event.
 * @class SpeechSynthesisWordBoundaryEventArgs
 * Added in version 1.11.0
 */
export declare class SpeechSynthesisWordBoundaryEventArgs {
    private readonly privAudioOffset;
    private readonly privDuration;
    private readonly privText;
    private readonly privWordLength;
    private readonly privTextOffset;
    private readonly privBoundaryType;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {number} audioOffset - The audio offset.
     * @param {number} duration - The audio duration.
     * @param {string} text - The text.
     * @param {number} wordLength - The length of the word.
     * @param {number} textOffset - The text offset.
     * @param {SpeechSynthesisBoundaryType} boundaryType - The boundary type
     */
    constructor(audioOffset: number, duration: number, text: string, wordLength: number, textOffset: number, boundaryType: SpeechSynthesisBoundaryType);
    /**
     * Specifies the audio offset.
     * @member SpeechSynthesisWordBoundaryEventArgs.prototype.audioOffset
     * @function
     * @public
     * @returns {number} the audio offset.
     */
    get audioOffset(): number;
    /**
     * Specifies the duration, in ticks (100 nanoseconds).
     * @member SpeechSynthesisWordBoundaryEventArgs.prototype.duration
     * @function
     * @public
     * @returns {number} Duration in 100 nanosecond increments.
     */
    get duration(): number;
    /**
     * Specifies the text of the word boundary event.
     * @member SpeechSynthesisWordBoundaryEventArgs.prototype.text
     * @function
     * @public
     * @returns {string} the text.
     */
    get text(): string;
    /**
     * Specifies the word length
     * @member SpeechSynthesisWordBoundaryEventArgs.prototype.wordLength
     * @function
     * @public
     * @returns {number} the word length
     */
    get wordLength(): number;
    /**
     * Specifies the text offset.
     * @member SpeechSynthesisWordBoundaryEventArgs.prototype.textOffset
     * @function
     * @public
     * @returns {number} the text offset.
     */
    get textOffset(): number;
    /**
     * Specifies the boundary type.
     * @member SpeechSynthesisWordBoundaryEventArgs.prototype.boundaryType
     * @function
     * @public
     * @returns {SpeechSynthesisBoundaryType} the boundary type.
     */
    get boundaryType(): SpeechSynthesisBoundaryType;
}
