/**
 * Defines the possible reasons a recognition result might be canceled.
 * @class CancellationReason
 */
export declare enum CancellationReason {
    /**
     * Indicates that an error occurred during speech recognition.
     * @member CancellationReason.Error
     */
    Error = 0,
    /**
     * Indicates that the end of the audio stream was reached.
     * @member CancellationReason.EndOfStream
     */
    EndOfStream = 1
}
