import { ConnectionEvent, EventSource, IAudioSource, IAudioStreamNode, IConnection, IDisposable, ServiceEvent } from "../common/Exports";
import { SpeakerRecognitionModel } from "../sdk/SpeakerRecognitionModel";
import { CancellationErrorCode, CancellationReason, Recognizer, SpeakerRecognitionResult, SpeechRecognitionResult } from "../sdk/Exports";
import { Callback } from "../sdk/Transcription/IConversation";
import { AgentConfig, DynamicGrammarBuilder, RecognitionMode, RequestSession, SpeechContext } from "./Exports";
import { IAuthentication } from "./IAuthentication";
import { IConnectionFactory } from "./IConnectionFactory";
import { RecognizerConfig } from "./RecognizerConfig";
import { SpeechConnectionMessage } from "./SpeechConnectionMessage.Internal";
export declare abstract class ServiceRecognizerBase implements IDisposable {
    private privAuthentication;
    private privConnectionFactory;
    private privConnectionConfigurationPromise;
    private privConnectionPromise;
    private privAuthFetchEventId;
    private privIsDisposed;
    private privMustReportEndOfStream;
    private privConnectionEvents;
    private privServiceEvents;
    private privDynamicGrammar;
    private privAgentConfig;
    private privServiceHasSentMessage;
    private privActivityTemplate;
    private privSetTimeout;
    private privAudioSource;
    private privIsLiveAudio;
    protected privSpeechContext: SpeechContext;
    protected privRequestSession: RequestSession;
    protected privConnectionId: string;
    protected privRecognizerConfig: RecognizerConfig;
    protected privRecognizer: Recognizer;
    protected privSuccessCallback: (e: SpeechRecognitionResult) => void;
    protected privErrorCallback: (e: string) => void;
    constructor(authentication: IAuthentication, connectionFactory: IConnectionFactory, audioSource: IAudioSource, recognizerConfig: RecognizerConfig, recognizer: Recognizer);
    get audioSource(): IAudioSource;
    get speechContext(): SpeechContext;
    get dynamicGrammar(): DynamicGrammarBuilder;
    get agentConfig(): AgentConfig;
    set conversationTranslatorToken(token: string);
    set voiceProfileType(type: string);
    set authentication(auth: IAuthentication);
    isDisposed(): boolean;
    dispose(reason?: string): Promise<void>;
    get connectionEvents(): EventSource<ConnectionEvent>;
    get serviceEvents(): EventSource<ServiceEvent>;
    get recognitionMode(): RecognitionMode;
    protected recognizeOverride: (recoMode: RecognitionMode, sc: (e: SpeechRecognitionResult) => void, ec: (e: string) => void) => Promise<void>;
    recognizeSpeaker: (model: SpeakerRecognitionModel) => Promise<SpeakerRecognitionResult>;
    recognize(recoMode: RecognitionMode, successCallback: (e: SpeechRecognitionResult) => void, errorCallBack: (e: string) => void): Promise<void>;
    stopRecognizing(): Promise<void>;
    connect(): Promise<void>;
    connectAsync(cb?: Callback, err?: Callback): void;
    protected disconnectOverride: () => Promise<void>;
    disconnect(): Promise<void>;
    static telemetryData: (json: string) => void;
    static telemetryDataEnabled: boolean;
    sendMessage(message: string): Promise<void>;
    sendNetworkMessage(path: string, payload: string | ArrayBuffer): Promise<void>;
    set activityTemplate(messagePayload: string);
    get activityTemplate(): string;
    protected abstract processTypeSpecificMessages(connectionMessage: SpeechConnectionMessage, successCallback?: (e: SpeechRecognitionResult) => void, errorCallBack?: (e: string) => void): Promise<boolean>;
    protected sendTelemetryData(): Promise<void>;
    protected abstract cancelRecognition(sessionId: string, requestId: string, cancellationReason: CancellationReason, errorCode: CancellationErrorCode, error: string): void;
    protected cancelRecognitionLocal(cancellationReason: CancellationReason, errorCode: CancellationErrorCode, error: string): Promise<void>;
    protected receiveMessageOverride: () => Promise<void>;
    protected receiveMessage(): Promise<void>;
    protected setSpeechSegmentationTimeout(): void;
    protected sendSpeechContext(connection: IConnection, generateNewRequestId: boolean): Promise<void>;
    protected sendPrePayloadJSONOverride: (connection: IConnection) => Promise<void>;
    protected noOp(): Promise<void>;
    protected sendPrePayloadJSON(connection: IConnection, generateNewRequestId?: boolean): Promise<void>;
    protected sendWaveHeader(connection: IConnection): Promise<void>;
    protected postConnectImplOverride: (connection: Promise<IConnection>) => Promise<IConnection>;
    protected connectImpl(): Promise<IConnection>;
    protected configConnectionOverride: (connection: IConnection) => Promise<IConnection>;
    protected handleSpeechPhraseMessage: (textBody: string) => Promise<void>;
    protected handleSpeechHypothesisMessage: (textBody: string) => void;
    protected sendSpeechServiceConfig(connection: IConnection, requestSession: RequestSession, SpeechServiceConfigJson: string): Promise<void>;
    protected fetchConnection(): Promise<IConnection>;
    protected sendAudio(audioStreamNode: IAudioStreamNode): Promise<void>;
    private retryableConnect;
    private delay;
    private writeBufferToConsole;
    private sendFinalAudio;
    private configureConnection;
}
