import { VoiceProfileType } from "./Exports";
/**
 * Defines Voice Profile class for Speaker Recognition
 * @class VoiceProfile
 */
export declare class VoiceProfile {
    private privId;
    private privProfileType;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {string} profileId - profileId of this Voice Profile.
     * @param {VoiceProfileType} profileType - profileType of this Voice Profile.
     */
    constructor(profileId: string, profileType: VoiceProfileType);
    /**
     * profileId of this Voice Profile instance
     * @member VoiceProfile.prototype.profileId
     * @function
     * @public
     * @returns {string} profileId of this Voice Profile instance.
     */
    get profileId(): string;
    /**
     * profileType of this Voice Profile instance
     * @member VoiceProfile.prototype.profileType
     * @function
     * @public
     * @returns {VoiceProfileType} profile type of this Voice Profile instance.
     */
    get profileType(): VoiceProfileType;
}
