// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT license.
/**
 * Defines the gender of synthesis voices.
 * Added in version 1.20.0.
 */
export var SynthesisVoiceGender;
(function (SynthesisVoiceGender) {
    /** Gender unknown */
    SynthesisVoiceGender[SynthesisVoiceGender["Unknown"] = 0] = "Unknown";
    /** Female voice */
    SynthesisVoiceGender[SynthesisVoiceGender["Female"] = 1] = "Female";
    /** Male voice */
    SynthesisVoiceGender[SynthesisVoiceGender["Male"] = 2] = "Male";
})(SynthesisVoiceGender || (SynthesisVoiceGender = {}));
export var SynthesisVoiceType;
(function (SynthesisVoiceType) {
    SynthesisVoiceType[SynthesisVoiceType["OnlineNeural"] = 1] = "OnlineNeural";
    SynthesisVoiceType[SynthesisVoiceType["OnlineStandard"] = 2] = "OnlineStandard";
    SynthesisVoiceType[SynthesisVoiceType["OfflineNeural"] = 3] = "OfflineNeural";
    SynthesisVoiceType[SynthesisVoiceType["OfflineStandard"] = 4] = "OfflineStandard";
})(SynthesisVoiceType || (SynthesisVoiceType = {}));
/**
 * Information about Speech Synthesis voice
 * Added in version 1.20.0.
 * @class VoiceInfo
 */
export class VoiceInfo {
    constructor(json) {
        this.privStyleList = [];
        this.privVoicePath = "";
        if (!!json) {
            this.privName = json.Name;
            this.privLocale = json.Locale;
            this.privShortName = json.ShortName;
            this.privLocalName = json.LocalName;
            this.privVoiceType = json.VoiceType.endsWith("Standard") ? SynthesisVoiceType.OnlineStandard : SynthesisVoiceType.OnlineNeural;
            this.privGender = json.Gender === "Male" ? SynthesisVoiceGender.Male : json.Gender === "Female" ? SynthesisVoiceGender.Female : SynthesisVoiceGender.Unknown;
            if (!!json.StyleList && Array.isArray(json.StyleList)) {
                for (const style of json.StyleList) {
                    this.privStyleList.push(style);
                }
            }
        }
    }
    get name() {
        return this.privName;
    }
    get locale() {
        return this.privLocale;
    }
    get shortName() {
        return this.privShortName;
    }
    get localName() {
        return this.privLocalName;
    }
    get gender() {
        return this.privGender;
    }
    get voiceType() {
        return this.privVoiceType;
    }
    get styleList() {
        return this.privStyleList;
    }
    get voicePath() {
        return this.privVoicePath;
    }
}

//# sourceMappingURL=VoiceInfo.js.map
