/**
 * Defines the gender of synthesis voices.
 * Added in version 1.20.0.
 */
export declare enum SynthesisVoiceGender {
    /** Gender unknown */
    Unknown = 0,
    /** Female voice */
    Female = 1,
    /** Male voice */
    Male = 2
}
export declare enum SynthesisVoiceType {
    OnlineNeural = 1,
    OnlineStandard = 2,
    OfflineNeural = 3,
    OfflineStandard = 4
}
/**
 * Information about Speech Synthesis voice
 * Added in version 1.20.0.
 * @class VoiceInfo
 */
export declare class VoiceInfo {
    private privName;
    private privLocale;
    private privShortName;
    private privLocalName;
    private privGender;
    private privVoiceType;
    private privStyleList;
    private privVoicePath;
    constructor(json: {
        Name: string;
        LocalName: string;
        ShortName: string;
        Gender: string;
        VoiceType: string;
        Locale: string;
        StyleList: string[];
    });
    get name(): string;
    get locale(): string;
    get shortName(): string;
    get localName(): string;
    get gender(): SynthesisVoiceGender;
    get voiceType(): SynthesisVoiceType;
    get styleList(): string[];
    get voicePath(): string;
}
