import { SynthesisResult, VoiceInfo } from "./Exports";
/**
 * Defines result of speech synthesis.
 * @class SynthesisVoicesResult
 * Added in version 1.20.0
 */
export declare class SynthesisVoicesResult extends SynthesisResult {
    private privVoices;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param requestId - result id for request.
     * @param json - json payload from endpoint.
     */
    constructor(requestId: string, json: any, errorDetails: string);
    /**
     * The list of voices
     * @member SynthesisVoicesResult.prototype.voices
     * @function
     * @public
     * @returns {VoiceInfo[]} List of synthesized voices.
     */
    get voices(): VoiceInfo[];
}
