/**
 * Defines contents of speech synthesis viseme event.
 * @class SpeechSynthesisVisemeEventArgs
 * Added in version 1.16.0
 */
export declare class SpeechSynthesisVisemeEventArgs {
    private privAudioOffset;
    private privVisemeId;
    private privAnimation;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {number} audioOffset - The audio offset.
     * @param {number} visemeId - The viseme ID.
     * @param {string} animation - The animation, could be in svg or other format.
     */
    constructor(audioOffset: number, visemeId: number, animation: string);
    /**
     * Specifies the audio offset.
     * @member SpeechSynthesisVisemeEventArgs.prototype.audioOffset
     * @function
     * @public
     * @returns {number} the audio offset.
     */
    get audioOffset(): number;
    /**
     * Specifies the viseme ID.
     * @member SpeechSynthesisVisemeEventArgs.prototype.visemeId
     * @function
     * @public
     * @returns {number} the viseme ID.
     */
    get visemeId(): number;
    /**
     * Specifies the animation.
     * @member SpeechSynthesisVisemeEventArgs.prototype.animation
     * @function
     * @public
     * @returns {string} the animation, could be in svg or other format.
     */
    get animation(): string;
}
