import { SpeechSynthesisResult } from "./Exports";
/**
 * Defines contents of speech synthesis events.
 * @class SpeechSynthesisEventArgs
 * Added in version 1.11.0
 */
export declare class SpeechSynthesisEventArgs {
    private readonly privResult;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {SpeechSynthesisResult} result - The speech synthesis result.
     */
    constructor(result: SpeechSynthesisResult);
    /**
     * Specifies the synthesis result.
     * @member SpeechSynthesisEventArgs.prototype.result
     * @function
     * @public
     * @returns {SpeechSynthesisResult} the synthesis result.
     */
    get result(): SpeechSynthesisResult;
}
