/**
 * Source Language configuration.
 * @class SourceLanguageConfig
 */
export declare class SourceLanguageConfig {
    private privLanguage;
    private privEndpointId;
    private constructor();
    /**
     * @member SourceLanguageConfig.fromLanguage
     * @function
     * @public
     * @param {string} language language (eg. "en-US") value of config.
     * @param {string?} endpointId endpointId of model bound to given language of config.
     * @return {SourceLanguageConfig} Instance of SourceLanguageConfig
     * @summary Creates an instance of the SourceLanguageConfig with the given language and optional endpointId.
     * Added in version 1.13.0.
     */
    static fromLanguage(language: string, endpointId?: string): SourceLanguageConfig;
    get language(): string;
    get endpointId(): string;
}
