// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT license.
/**
 * Allows additions of new phrases to improve speech recognition.
 *
 * Phrases added to the recognizer are effective at the start of the next recognition, or the next time the SpeechSDK must reconnect
 * to the speech service.
 */
export class PhraseListGrammar {
    constructor(recogBase) {
        this.privGrammerBuilder = recogBase.dynamicGrammar;
    }
    /**
     * Creates a PhraseListGrammar from a given speech recognizer. Will accept any recognizer that derives from @class Recognizer.
     * @param recognizer The recognizer to add phrase lists to.
     */
    static fromRecognizer(recognizer) {
        const recoBase = recognizer.internalData;
        return new PhraseListGrammar(recoBase);
    }
    /**
     * Adds a single phrase to the current recognizer.
     * @param phrase Phrase to add.
     */
    addPhrase(phrase) {
        this.privGrammerBuilder.addPhrase(phrase);
    }
    /**
     * Adds multiple phrases to the current recognizer.
     * @param phrases Array of phrases to add.
     */
    addPhrases(phrases) {
        this.privGrammerBuilder.addPhrase(phrases);
    }
    /**
     * Clears all phrases added to the current recognizer.
     */
    clear() {
        this.privGrammerBuilder.clearPhrases();
    }
}

//# sourceMappingURL=PhraseListGrammar.js.map
