//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
export class ConnectionMessageEventArgs {
    constructor(message) {
        this.privConnectionMessage = message;
    }
    /**
     * Gets the <see cref="ConnectionMessage"/> associated with this <see cref="ConnectionMessageEventArgs"/>.
     */
    get message() {
        return this.privConnectionMessage;
    }
    /**
     * Returns a string that represents the connection message event.
     */
    toString() {
        return "Message: " + this.privConnectionMessage.toString();
    }
}

//# sourceMappingURL=ConnectionMessageEventArgs.js.map
