/**
 * An abstract base class that defines callback methods (write() and close()) for
 * custom audio output streams).
 * @class PushAudioOutputStreamCallback
 */
export declare abstract class PushAudioOutputStreamCallback {
    /**
     * Writes audio data into the data buffer.
     * @member PushAudioOutputStreamCallback.prototype.write
     * @function
     * @public
     * @param {ArrayBuffer} dataBuffer - The byte array that stores the audio data to write.
     */
    abstract write(dataBuffer: ArrayBuffer): void;
    /**
     * Closes the audio output stream.
     * @member PushAudioOutputStreamCallback.prototype.close
     * @function
     * @public
     */
    abstract close(): void;
}
