import { ConnectionEvent, EventSource, IAudioDestination, IConnection, IDisposable, ServiceEvent } from "../common/Exports";
import { AudioOutputFormatImpl } from "../sdk/Audio/AudioOutputFormat";
import { CancellationErrorCode, CancellationReason, SpeechSynthesisResult, SpeechSynthesizer } from "../sdk/Exports";
import { AgentConfig, ISynthesisConnectionFactory, SynthesisContext, SynthesisTurn, SynthesizerConfig } from "./Exports";
import { IAuthentication } from "./IAuthentication";
import { SpeechConnectionMessage } from "./SpeechConnectionMessage.Internal";
export declare class SynthesisAdapterBase implements IDisposable {
    protected privSynthesisTurn: SynthesisTurn;
    protected privConnectionId: string;
    protected privSynthesizerConfig: SynthesizerConfig;
    protected privSpeechSynthesizer: SpeechSynthesizer;
    protected privSuccessCallback: (e: SpeechSynthesisResult) => void;
    protected privErrorCallback: (e: string) => void;
    get synthesisContext(): SynthesisContext;
    get agentConfig(): AgentConfig;
    get connectionEvents(): EventSource<ConnectionEvent>;
    get serviceEvents(): EventSource<ServiceEvent>;
    protected speakOverride: (ssml: string, requestId: string, sc: (e: SpeechSynthesisResult) => void, ec: (e: string) => void) => void;
    static telemetryData: (json: string) => void;
    static telemetryDataEnabled: boolean;
    set activityTemplate(messagePayload: string);
    get activityTemplate(): string;
    protected receiveMessageOverride: () => void;
    protected connectImplOverride: (isUnAuthorized: boolean) => void;
    protected configConnectionOverride: (connection: IConnection) => Promise<IConnection>;
    set audioOutputFormat(format: AudioOutputFormatImpl);
    private privAuthentication;
    private privConnectionFactory;
    private privConnectionConfigurationPromise;
    private privConnectionPromise;
    private privAuthFetchEventId;
    private privIsDisposed;
    private privConnectionEvents;
    private privServiceEvents;
    private privSynthesisContext;
    private privAgentConfig;
    private privActivityTemplate;
    private privAudioOutputFormat;
    private privSessionAudioDestination;
    constructor(authentication: IAuthentication, connectionFactory: ISynthesisConnectionFactory, synthesizerConfig: SynthesizerConfig, speechSynthesizer: SpeechSynthesizer, audioDestination: IAudioDestination);
    static addHeader(audio: ArrayBuffer, format: AudioOutputFormatImpl): ArrayBuffer;
    isDisposed(): boolean;
    dispose(reason?: string): Promise<void>;
    connect(): Promise<void>;
    sendNetworkMessage(path: string, payload: string | ArrayBuffer): Promise<void>;
    Speak(text: string, isSSML: boolean, requestId: string, successCallback: (e: SpeechSynthesisResult) => void, errorCallBack: (e: string) => void, audioDestination: IAudioDestination): Promise<void>;
    protected cancelSynthesis(requestId: string, cancellationReason: CancellationReason, errorCode: CancellationErrorCode, error: string): void;
    protected cancelSynthesisLocal(cancellationReason: CancellationReason, errorCode: CancellationErrorCode, error: string): void;
    protected processTypeSpecificMessages(connectionMessage: SpeechConnectionMessage): boolean;
    protected receiveMessage(): Promise<void>;
    protected sendSynthesisContext(connection: IConnection): Promise<void>;
    protected connectImpl(isUnAuthorized?: boolean): Promise<IConnection>;
    protected sendSpeechServiceConfig(connection: IConnection, SpeechServiceConfigJson: string): Promise<void>;
    protected sendSsmlMessage(connection: IConnection, ssml: string, requestId: string): Promise<void>;
    private fetchConnection;
    private configureConnection;
}
