/**
 * @class SynthesisStatus
 * @private
 */
export declare enum SynthesisStatus {
    /**
     * The response contains valid audio data.
     * @member SynthesisStatus.Success
     */
    Success = 0,
    /**
     * Indicates the end of audio data. No valid audio data is included in the message.
     * @member SynthesisStatus.SynthesisEnd
     */
    SynthesisEnd = 1,
    /**
     * Indicates an error occurred during synthesis data processing.
     * @member SynthesisStatus.Error
     */
    Error = 2
}
export declare enum RecognitionStatus {
    Success = 0,
    NoMatch = 1,
    InitialSilenceTimeout = 2,
    BabbleTimeout = 3,
    Error = 4,
    EndOfDictation = 5,
    TooManyRequests = 6,
    BadRequest = 7,
    Forbidden = 8
}
