"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT license.
Object.defineProperty(exports, "__esModule", { value: true });
exports.VoiceProfileType = void 0;
/**
 * Output format
 * @class VoiceProfileType
 */
var VoiceProfileType;
(function (VoiceProfileType) {
    /**
     * Text independent speaker identification
     * @member VoiceProfileType.TextIndependentIdentification
     */
    VoiceProfileType[VoiceProfileType["TextIndependentIdentification"] = 0] = "TextIndependentIdentification";
    /**
     * Text dependent speaker verification
     * @member VoiceProfileType.TextDependentVerification
     */
    VoiceProfileType[VoiceProfileType["TextDependentVerification"] = 1] = "TextDependentVerification";
    /**
     * Text independent speaker verification
     * @member VoiceProfileType.TextIndependentVerification
     */
    VoiceProfileType[VoiceProfileType["TextIndependentVerification"] = 2] = "TextIndependentVerification";
})(VoiceProfileType = exports.VoiceProfileType || (exports.VoiceProfileType = {}));

//# sourceMappingURL=VoiceProfileType.js.map
