/**
 * Defines contents of received message/events.
 * @class TurnStatusReceivedEventArgs
 */
export declare class TurnStatusReceivedEventArgs {
    private privTurnStatus;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {string} turnStatus - The JSON-encoded turn status message.
     */
    constructor(turnStatus: string);
    /**
     * Gets the interaction identifier associated with this turn status event.
     * @member TurnStatusReceivedEventArgs.prototype.interactionId
     * @function
     * @public
     * @returns {any} the received interaction id.
     */
    get interactionId(): any;
    /**
     * Gets the conversation identifier associated with this turn status event.
     * @member TurnStatusReceivedEventArgs.prototype.conversationId
     * @function
     * @public
     * @returns {any} the received conversation id.
     */
    get conversationId(): any;
    /**
     * Gets the received turn status code.
     * @member TurnStatusReceivedEventArgs.prototype.statusCode
     * @function
     * @public
     * @returns {number} the received turn status.
     */
    get statusCode(): number;
}
