import { SessionEventArgs, TranslationSynthesisResult } from "./Exports";
/**
 * Translation Synthesis event arguments
 * @class TranslationSynthesisEventArgs
 */
export declare class TranslationSynthesisEventArgs extends SessionEventArgs {
    private privResult;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {TranslationSynthesisResult} result - The translation synthesis result.
     * @param {string} sessionId - The session id.
     */
    constructor(result: TranslationSynthesisResult, sessionId?: string);
    /**
     * Specifies the translation synthesis result.
     * @member TranslationSynthesisEventArgs.prototype.result
     * @function
     * @public
     * @returns {TranslationSynthesisResult} Specifies the translation synthesis result.
     */
    get result(): TranslationSynthesisResult;
}
