import { RecognitionEventArgs, TranslationRecognitionResult } from "./Exports";
/**
 * Translation text result event arguments.
 * @class TranslationRecognitionEventArgs
 */
export declare class TranslationRecognitionEventArgs extends RecognitionEventArgs {
    private privResult;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {TranslationRecognitionResult} result - The translation recognition result.
     * @param {number} offset - The offset.
     * @param {string} sessionId - The session id.
     */
    constructor(result: TranslationRecognitionResult, offset?: number, sessionId?: string);
    /**
     * Specifies the recognition result.
     * @member TranslationRecognitionEventArgs.prototype.result
     * @function
     * @public
     * @returns {TranslationRecognitionResult} the recognition result.
     */
    get result(): TranslationRecognitionResult;
}
