import { CancellationDetailsBase } from "./CancellationDetailsBase";
import { RecognitionResult, SpeechSynthesisResult } from "./Exports";
/**
 * Contains detailed information about why a result was canceled.
 * @class CancellationDetails
 */
export declare class CancellationDetails extends CancellationDetailsBase {
    private constructor();
    /**
     * Creates an instance of CancellationDetails object for the canceled RecognitionResult.
     * @member CancellationDetails.fromResult
     * @function
     * @public
     * @param {RecognitionResult | SpeechSynthesisResult} result - The result that was canceled.
     * @returns {CancellationDetails} The cancellation details object being created.
     */
    static fromResult(result: RecognitionResult | SpeechSynthesisResult): CancellationDetails;
}
