import { IDetachable } from "./IDetachable";
import { IDisposable } from "./IDisposable";
export interface IList<TItem> extends IDisposable {
    get(itemIndex: number): TItem;
    first(): TItem;
    last(): TItem;
    add(item: TItem): void;
    insertAt(index: number, item: TItem): void;
    removeFirst(): TItem;
    removeLast(): TItem;
    removeAt(index: number): TItem;
    remove(index: number, count: number): TItem[];
    clear(): void;
    length(): number;
    onAdded(addedCallback: () => void): IDetachable;
    onRemoved(removedCallback: () => void): IDetachable;
    onDisposed(disposedCallback: () => void): IDetachable;
    join(seperator?: string): string;
    toArray(): TItem[];
    any(callback?: (item: TItem, index: number) => boolean): boolean;
    all(callback: (item: TItem) => boolean): boolean;
    forEach(callback: (item: TItem, index: number) => void): void;
    select<T2>(callback: (item: TItem, index: number) => T2): List<T2>;
    where(callback: (item: TItem, index: number) => boolean): List<TItem>;
    orderBy(compareFn: (a: TItem, b: TItem) => number): List<TItem>;
    orderByDesc(compareFn: (a: TItem, b: TItem) => number): List<TItem>;
    clone(): List<TItem>;
    concat(list: List<TItem>): List<TItem>;
    concatArray(array: TItem[]): List<TItem>;
}
export declare class List<TItem> implements IList<TItem> {
    private privList;
    private privSubscriptionIdCounter;
    private privAddSubscriptions;
    private privRemoveSubscriptions;
    private privDisposedSubscriptions;
    private privDisposeReason;
    constructor(list?: TItem[]);
    get(itemIndex: number): TItem;
    first(): TItem;
    last(): TItem;
    add(item: TItem): void;
    insertAt(index: number, item: TItem): void;
    removeFirst(): TItem;
    removeLast(): TItem;
    removeAt(index: number): TItem;
    remove(index: number, count: number): TItem[];
    clear(): void;
    length(): number;
    onAdded(addedCallback: () => void): IDetachable;
    onRemoved(removedCallback: () => void): IDetachable;
    onDisposed(disposedCallback: () => void): IDetachable;
    join(seperator?: string): string;
    toArray(): TItem[];
    any(callback?: (item: TItem, index: number) => boolean): boolean;
    all(callback: (item: TItem) => boolean): boolean;
    forEach(callback: (item: TItem, index: number) => void): void;
    select<T2>(callback: (item: TItem, index: number) => T2): List<T2>;
    where(callback: (item: TItem, index: number) => boolean): List<TItem>;
    orderBy(compareFn: (a: TItem, b: TItem) => number): List<TItem>;
    orderByDesc(compareFn: (a: TItem, b: TItem) => number): List<TItem>;
    clone(): List<TItem>;
    concat(list: List<TItem>): List<TItem>;
    concatArray(array: TItem[]): List<TItem>;
    isDisposed(): boolean;
    dispose(reason?: string): void;
    private throwIfDisposed;
    private triggerSubscriptions;
}
