/**
 * Defines contents of speech synthesis bookmark event.
 * @class SpeechSynthesisBookmarkEventArgs
 * Added in version 1.16.0
 */
export declare class SpeechSynthesisBookmarkEventArgs {
    private privAudioOffset;
    private privText;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {number} audioOffset - The audio offset.
     * @param {string} text - The bookmark text.
     */
    constructor(audioOffset: number, text: string);
    /**
     * Specifies the audio offset.
     * @member SpeechSynthesisBookmarkEventArgs.prototype.audioOffset
     * @function
     * @public
     * @returns {number} the audio offset.
     */
    get audioOffset(): number;
    /**
     * Specifies the bookmark.
     * @member SpeechSynthesisBookmarkEventArgs.prototype.text
     * @function
     * @public
     * @returns {string} the bookmark text.
     */
    get text(): string;
}
