import { SessionEventArgs } from "./Exports";
/**
 * Defines payload for session events like Speech Start/End Detected
 * @class
 */
export declare class RecognitionEventArgs extends SessionEventArgs {
    private privOffset;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param {number} offset - The offset.
     * @param {string} sessionId - The session id.
     */
    constructor(offset: number, sessionId?: string);
    /**
     * Represents the message offset
     * @member RecognitionEventArgs.prototype.offset
     * @function
     * @public
     */
    get offset(): number;
}
