/**
 * Defines the possible reasons a recognition result might not be recognized.
 * @class NoMatchReason
 */
export declare enum NoMatchReason {
    /**
     * Indicates that speech was detected, but not recognized.
     * @member NoMatchReason.NotRecognized
     */
    NotRecognized = 0,
    /**
     * Indicates that the start of the audio stream contained only silence,
     * and the service timed out waiting for speech.
     * @member NoMatchReason.InitialSilenceTimeout
     */
    InitialSilenceTimeout = 1,
    /**
     * Indicates that the start of the audio stream contained only noise,
     * and the service timed out waiting for speech.
     * @member NoMatchReason.InitialBabbleTimeout
     */
    InitialBabbleTimeout = 2
}
