import { IntentRecognitionResult, RecognitionEventArgs } from "./Exports";
/**
 * Intent recognition result event arguments.
 * @class
 */
export declare class IntentRecognitionEventArgs extends RecognitionEventArgs {
    private privResult;
    /**
     * Creates and initializes an instance of this class.
     * @constructor
     * @param result - The result of the intent recognition.
     * @param offset - The offset.
     * @param sessionId - The session id.
     */
    constructor(result: IntentRecognitionResult, offset?: number, sessionId?: string);
    /**
     * Represents the intent recognition result.
     * @member IntentRecognitionEventArgs.prototype.result
     * @function
     * @public
     * @returns {IntentRecognitionResult} Represents the intent recognition result.
     */
    get result(): IntentRecognitionResult;
}
