//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
import { ConsoleLoggingListener } from "../common.browser/Exports";
import { Events } from "../common/Exports";
/**
 * Defines diagnostics API for managing console output
 * Added in version 1.21.0
 */
export class Diagnostics {
    static SetLoggingLevel(logLevel) {
        this.privListener = new ConsoleLoggingListener(logLevel);
        Events.instance.attachConsoleListener(this.privListener);
    }
    static StartConsoleOutput() {
        if (!!this.privListener) {
            this.privListener.enableConsoleOutput = true;
        }
    }
    static StopConsoleOutput() {
        if (!!this.privListener) {
            this.privListener.enableConsoleOutput = false;
        }
    }
    static SetLogOutputPath(path) {
        if (typeof window === "undefined") {
            if (!!this.privListener) {
                this.privListener.logPath = path;
            }
        }
        else {
            throw new Error("File system logging not available in browser.");
        }
    }
}
Diagnostics.privListener = undefined;

//# sourceMappingURL=Diagnostics.js.map
