/**
 * Defines error code in case that CancellationReason is Error.
 * Added in version 1.1.0.
 */
export declare enum CancellationErrorCode {
    /**
     * Indicates that no error occurred during speech recognition.
     */
    NoError = 0,
    /**
     * Indicates an authentication error.
     */
    AuthenticationFailure = 1,
    /**
     * Indicates that one or more recognition parameters are invalid.
     */
    BadRequestParameters = 2,
    /**
     * Indicates that the number of parallel requests exceeded the number of allowed
     * concurrent transcriptions for the subscription.
     */
    TooManyRequests = 3,
    /**
     * Indicates a connection error.
     */
    ConnectionFailure = 4,
    /**
     * Indicates a time-out error when waiting for response from service.
     */
    ServiceTimeout = 5,
    /**
     * Indicates that an error is returned by the service.
     */
    ServiceError = 6,
    /**
     * Indicates an unexpected runtime error.
     */
    RuntimeError = 7,
    /**
     * Indicates an quota overrun on existing key.
     */
    Forbidden = 8
}
