let recognizer;
const transcriptionDiv = document.createElement("div");
document.body.appendChild(transcriptionDiv);

window.startTranscription = async function() {
  const speechConfig = new SpeechSDK.SpeechConfig.fromSubscription(
    "8720fb2091b1458c9b9457f167bd7fb5",
    "uaenorth"
  );
  speechConfig.speechRecognitionLanguage = "ar-SA";
  const audioConfig = SpeechSDK.AudioConfig.fromDefaultMicrophoneInput();
  recognizer = new SpeechSDK.SpeechRecognizer(speechConfig, audioConfig);

  recognizer.recognizing = (s, e) => {
    console.log(`RECOGNIZING: Text=${e.result.text}`);
    transcriptionDiv.textContent = e.result.text;
  };

  recognizer.recognized = (s, e) => {
    if (e.result.reason === SpeechSDK.ResultReason.RecognizedSpeech) {
      console.log(`RECOGNIZED: Text=${e.result.text}`);
      // const div = document.createElement("div");
      // div.textContent = e.result.text;
      // document.getElementById("transcriptions").appendChild(div);
    } else if (e.result.reason === SpeechSDK.ResultReason.NoMatch) {
      console.log("NOMATCH: Speech could not be recognized.");
    }
  };

  recognizer.startContinuousRecognitionAsync();
}

window.stopTranscription = function() {
  recognizer.stopContinuousRecognitionAsync();
}

